<?php
require_once 'includes/config.php';
require_once 'includes/db.php';

// Get service ID from URL
$serviceId = $_GET['id'] ?? null;

if (!$serviceId) {
    header("Location: services.php");
    exit;
}

// Get service details
$stmt = $pdo->prepare("SELECT * FROM services WHERE id = ?");
$stmt->execute([$serviceId]);
$service = $stmt->fetch();

if (!$service) {
    header("Location: services.php");
    exit;
}

$features = $pdo->prepare("SELECT * FROM service_features WHERE service_id = ? ORDER BY sort_order");
$features->execute([$serviceId]);
$features = $features->fetchAll();

// Get related services (excluding current one)
$relatedServices = $pdo->prepare("SELECT * FROM services WHERE id != ? ORDER BY RAND() LIMIT 3");
$relatedServices->execute([$serviceId]);
$relatedServices = $relatedServices->fetchAll();
?>
<?php
include('includes/header.php');
?>

    <!-- Service Detail Section -->
    <section class="service-detail">
        <div class="container">
            <div class="service-header">
                <?php if (!empty($service['icon'])): ?>
                <div class="service-icon">
                    <i class="<?= htmlspecialchars($service['icon']) ?>"></i>
                </div>
                <?php endif; ?>
                <h1><?= htmlspecialchars($service['title']) ?></h1>
                <div class="divider"></div>
            </div>
            
            <div class="service-content3">
                <div class="service-image">
                    <?php if (!empty($service['image_url'])): ?>
                    <img src="<?= $service['image_url'] ?>" alt="<?= htmlspecialchars($service['title']) ?>">
                    <?php else: ?>
                    <img src="assets/images/default-service.jpg" alt="Default service image">
                    <?php endif; ?>
                </div>
                
        <div class="service-description">
    <p><?= nl2br(htmlspecialchars($service['description'])) ?></p>
    
    <?php if (!empty($features)): ?>
    <div class="service-features">
        <h3>Key Features</h3>
        <?php foreach ($features as $feature): ?>
        <div class="feature-item">
            <div class="feature-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="feature-text">
                <?= htmlspecialchars($feature['feature_text']) ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>
    
    <a href="index.php#contact" class="btn">Get a Quote</a>
</div>
            </div>
            
         <div class="related-services" id="related-services">
    <div class="container">
        <div class="section-title">
            <h2>Other Services</h2>
        </div>
        <div class="related-services-grid">
            <?php foreach ($relatedServices as $related): 
                $icon = 'fas fa-cog';
                $title = strtolower($related['title']);
                if (strpos($title, 'welding') !== false) {
                    $icon = 'fas fa-wrench';
                } elseif (strpos($title, 'civil') !== false) {
                    $icon = 'fas fa-building';
                } elseif (strpos($title, 'earthwork') !== false) {
                    $icon = 'fas fa-truck-pickup';
                } elseif (strpos($title, 'industrial') !== false) {
                    $icon = 'fas fa-industry';
                }
            ?>
            <div class="custom-service-card">
                <div class="service-icon"><i class="<?= $icon ?>"></i></div>
                <h3><?= htmlspecialchars($related['title']) ?></h3>
                <div class="service-content">
                    <?php 
                    $bulletPoints = preg_split('/\s*-\s*/', $related['description'], -1, PREG_SPLIT_NO_EMPTY);
                    $maxVisible = 2;
                    $count = 0;
                    foreach ($bulletPoints as $point):
                        $point = trim($point);
                        if (!empty($point)):
                            if ($count < $maxVisible):
                    ?>
                    <div class="bullet-point">
                        <i class="fas fa-check check-icon"></i>
                        <span><?= htmlspecialchars($point) ?></span>
                    </div>
                    <?php
                            $count++;
                            else:
                                if ($count === $maxVisible):
                    ?>
                    <div class="bullet-point">
                        <i class="fas fa-ellipsis-h check-icon"></i>
                    </div>
                    <?php
                                break;
                                endif;
                            endif;
                        endif;
                    endforeach;
                    ?>
                </div>
                <a href="service.php?id=<?= $related['id'] ?>" class="btn btn-outline">
                    Explore Service <i class="fas fa-arrow-right"></i>
                </a>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</div>

        </div>
    </section>

    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="social-links">
                <a href="#"><i class="fab fa-facebook-f"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-linkedin-in"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
            </div>
            <ul class="footer-links">
                <li><a href="index.php#home">Home</a></li>
                <li><a href="index.php#about">About</a></li>
                <li><a href="index.php#services">Services</a></li>
                <li><a href="index.php#projects">Projects</a></li>
                <li><a href="index.php#gallery">Gallery</a></li>
                <li><a href="index.php#contact">Contact</a></li>
            </ul>
            <p>&copy; <?= date('Y') ?> Ets Taher. All Rights Reserved.</p>
        </div>
    </footer>

    <script src="assets/js/script.js"></script>
</body>
</html>