<?php
require_once 'includes/config.php';
require_once 'includes/db.php';

// Get all website content
$content = [];
$result = $pdo->query("SELECT * FROM website_content");
while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
    $content[$row['section']] = $row;
}

// Get gallery images
$gallery = $pdo->query("SELECT * FROM gallery_images ORDER BY uploaded_at DESC")->fetchAll(PDO::FETCH_ASSOC);

$services = $pdo->query("SELECT * FROM services ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);

// Get projects from database
$projects = $pdo->query("SELECT * FROM projects ORDER BY completed_date DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<?php
include('includes/header.php');
?>
    <!-- Hero Section -->
    <section class="hero" id="home" style="background-image: url('<?= $content['hero']['image_url'] ?? 'assets/images/default-hero.jpg' ?>')">
        <div class="hero-content">
            <h1><?= $content['hero']['title'] ?? 'Construction et travaux publics' ?></h1>
            <p><?= $content['hero']['content'] ?? 'Specialized in civil engineering, earthworks, industrial assembly, and welding in Mauritania' ?></p>
            <a href="#contact" class="btn">Get in Touch</a>
        </div>
    </section>

    <!-- About Section -->
<section class="about" id="about">
    <div class="container">
        <div class="section-title">
            <h2>About Us</h2>
        </div>
        <div class="about-content">
            <div class="about-text">
                <h3><?= $content['about']['title'] ?? 'Presentation of Ets Taher' ?></h3>
                <p><?= $content['about']['content'] ?? 'Ets Taher is a Mauritanian company specialized in civil engineering, earthworks, industrial assembly, and welding.' ?></p>
                <a href="about.php" class="btn read-more">Read More</a>
            </div>
            <div class="about-image">
                <img src="<?= $content['about']['image_url'] ?? 'assets/images/default-about.jpg' ?>" alt="About Ets Taher">
            </div>
        </div>
    </div>
</section>

    <!-- Services Section -->
<!-- Services Section -->
<!-- Services Section -->
<section class="services" id="services">
    <div class="container">
        <div class="section-title">
            <h2>Our Services</h2>
        </div>
        <div class="services-grid four-column">
            <?php foreach ($services as $service): 
                // Set icon based on service title
                $icon = 'fas fa-cog'; // default icon
                $title = strtolower($service['title']);
                if (strpos($title, 'welding') !== false) {
                    $icon = 'fas fa-wrench';
                } elseif (strpos($title, 'civil') !== false) {
                    $icon = 'fas fa-building';
                } elseif (strpos($title, 'earthwork') !== false) {
                    $icon = 'fas fa-truck-pickup';
                } elseif (strpos($title, 'industrial') !== false) {
                    $icon = 'fas fa-industry';
                }
            ?>
            <div class="service-card modern-card">
                <div class="service-icon">
                    <i class="<?= $icon ?>"></i>
                </div>
                <h3><?= htmlspecialchars($service['title']) ?></h3>
             <div class="service-content">
    <?php 
    // Split description into bullet points
    $bulletPoints = preg_split('/\s*-\s*/', $service['description'], -1, PREG_SPLIT_NO_EMPTY);
    $maxVisible = 2; // Show only first 2 points
    $count = 0;
    
    foreach ($bulletPoints as $index => $point):
        $point = trim($point);
        if (!empty($point)):
            if ($count < $maxVisible):
    ?>
                <div class="bullet-point">
                    <i class="fas fa-check check-icon"></i>
                    <span><?= htmlspecialchars($point) ?></span>
                </div>
    <?php
                $count++;
            else:
                // Show "..." only once
                if ($count === $maxVisible):
    ?>
                <div class="bullet-point">
                    <i class="fas fa-ellipsis-h check-icon"></i>
           
                </div>
    <?php
                    break;
                endif;
            endif;
        endif;
    endforeach; 
    ?>
</div>

                <a href="service.php?id=<?= $service['id'] ?>" class="btn btn-outline">
                    Explore Service <i class="fas fa-arrow-right"></i>
                </a>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<section class="projects" id="projects">
    <div class="container">
        <div class="section-title">
            <h2>Our Projects </h2>
         
            <p class="section-subtitle">Explore our portfolio of successful constructions and engineering projects</p>
        </div>
        
     
        <div class="projects-grid">
            <?php foreach ($projects as $project): 
                $status = strtotime($project['completed_date']) > time() ? 'ongoing' : 'completed';
                $categories = $project['categories'] ?? [];
            ?>
            <div class="project-card" data-status="<?= $status ?>" data-categories="<?= implode(' ', $categories) ?>">
                <div class="project-image">
                    <img src="<?= $project['image_url'] ?? 'assets/images/default-project.jpg' ?>" alt="<?= htmlspecialchars($project['title']) ?>">
                    <!-- <span class="project-badge <?= $status ?>">
                        <?= ucfirst($status) ?>
                    </span> -->
                 <div class="project-overlay">
    <a href="project.php?id=<?= $project['id'] ?>" class="view-details">View Details <i class="fas fa-arrow-right"></i></a>
</div>
                </div>
                <div class="project-info">
                    <div class="project-meta">
                        <span class="client"><i class="fas fa-building"></i> <?= htmlspecialchars($project['client']) ?></span>
                        <span class="location"><i class="fas fa-map-marker-alt"></i> <?= htmlspecialchars($project['location']) ?></span>
                    </div>
                    <h3><?= htmlspecialchars($project['title']) ?></h3>
                    <p class="project-description"><?= htmlspecialchars($project['short_description'] ?? '') ?></p>
                    <div class="project-footer">
                        <span class="project-date"><i class="far fa-calendar-alt"></i> <?= date('M Y', strtotime($project['completed_date'])) ?></span>
                        <div class="project-categories">
                            <?php foreach ($categories as $category): ?>
                                <span class="category-tag"><?= htmlspecialchars($category) ?></span>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <div class="projects-cta">
            <p>Have a project in mind? Let's build it together!</p>
            <a href="#contact" class="btn btn-primary">Get a Quote</a>
        </div>
    </div>
</section>
    <!-- Gallery Section -->
    <section class="gallery" id="gallery">
    <div class="container">
        <div class="section-title">
            <h2>Our Gallery</h2>
        </div>
        
        <?php
        // Pagination setup
        $imagesPerPage = 8;
        $totalImages = count($gallery);
        $totalPages = ceil($totalImages / $imagesPerPage);
        
        // Get current page from URL, default to 1
        $currentPage = isset($_GET['page']) ? max(1, min($totalPages, (int)$_GET['page'])) : 1;
        
        // Calculate offset
        $offset = ($currentPage - 1) * $imagesPerPage;
        
        // Get images for current page
        $currentPageImages = array_slice($gallery, $offset, $imagesPerPage);
        ?>
        
        <div class="gallery-grid">
            <?php foreach ($currentPageImages as $image): ?>
            <div class="gallery-item">
                <img src="<?= $image['image_url'] ?>" alt="<?= $image['caption'] ?? 'Gallery Image' ?>" data-caption="<?= $image['caption'] ?? '' ?>">
                <div class="gallery-overlay">
                    <i class="fas fa-search-plus"></i>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Pagination -->
        <?php if ($totalPages > 1): ?>
        <div class="gallery-pagination">
            <?php if ($currentPage > 1): ?>
                <a href="?page=<?= $currentPage - 1 ?>#gallery" class="page-link"><i class="fas fa-chevron-left"></i> Previous</a>
            <?php endif; ?>
            
            <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                <a href="?page=<?= $i ?>#gallery" class="page-link <?= $i == $currentPage ? 'active' : '' ?>"><?= $i ?></a>
            <?php endfor; ?>
            
            <?php if ($currentPage < $totalPages): ?>
                <a href="?page=<?= $currentPage + 1 ?>#gallery" class="page-link">Next <i class="fas fa-chevron-right"></i></a>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
</section>

    <!-- Lightbox Modal -->
    <div class="lightbox" id="lightbox">
        <span class="close-btn">&times;</span>
        <img class="lightbox-content" id="lightbox-img">
        <div class="caption" id="caption"></div>
        <a class="prev">&#10094;</a>
        <a class="next">&#10095;</a>
    </div>

    <!-- Contact Section -->
    <section class="contact" id="contact">
        <div class="container">
            <div class="section-title">
                <h2>Contact Us</h2>
            </div>
            <div class="contact-container">
                <div class="contact-info">
                    <h3>Get in Touch</h3>
                    <p><i class="fas fa-map-marker-alt"></i> Mauritania</p>
                    <p><i class="fas fa-phone"></i>+222 22 42 14 15</p>
                    <p><i class="fas fa-envelope"></i> info@etstaher.com</p>
                    <!-- <p><i class="fas fa-clock"></i> Mon-Fri: 8:00 - 17:00</p> -->
                </div>
                <div class="contact-form">
                    <form id="contactForm" method="POST" action="send_email.php">
                        <input type="text" name="name" placeholder="Your Name" required>
                        <input type="email" name="email" placeholder="Your Email" required>
                        <input type="text" name="subject" placeholder="Subject">
                        <textarea name="message" placeholder="Your Message" required></textarea>
                        <button type="submit">Send Message</button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer>
        <div class="container">
            <div class="social-links">
                <a href="#"><i class="fab fa-facebook-f"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-linkedin-in"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
            </div>
            <ul class="footer-links">
                <li><a href="#home">Home</a></li>
                <li><a href="#about">About</a></li>
                <li><a href="#services">Services</a></li>
                <li><a href="#projects">Projects</a></li>
                <li><a href="#gallery">Gallery</a></li>
                <li><a href="#contact">Contact</a></li>
            </ul>
            <p>&copy; <?= date('Y') ?> Ets Taher. All Rights Reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
    <script src="assets/js/script.js"></script>
</body>
</html>