<?php
require_once '../includes/config.php';
requireAuth();
require_once '../includes/functions.php';

$sections = getWebsiteContent();
$gallery = getAllGalleryImages();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?= SITE_NAME ?></title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css">
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f8f9fa;
        }
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            bottom: 0;
            width: 250px;
            background-color: #1a5276;
            color: white;
            padding: 20px 0;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
        }
        .main-content {
            margin-left: 250px;
            padding: 20px;
        }
        .sidebar-header {
            padding: 0 20px 20px;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }
        .sidebar-menu {
            padding: 20px 0;
        }
        .sidebar-menu a {
            display: block;
            padding: 10px 20px;
            color: white;
            text-decoration: none;
            transition: background-color 0.3s;
        }
        .sidebar-menu a:hover, .sidebar-menu a.active {
            background-color: rgba(255, 255, 255, 0.1);
        }
        .sidebar-menu i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        .card {
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            border: none;
        }
        .card-header {
            background-color: white;
            border-bottom: 1px solid rgba(0, 0, 0, 0.1);
            font-weight: 600;
            padding: 15px 20px;
            border-radius: 10px 10px 0 0 !important;
        }
        .gallery-img {
            height: 150px;
            object-fit: cover;
            border-radius: 5px;
        }
        .section-img {
            height: 100px;
            object-fit: cover;
            border-radius: 5px;
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="sidebar-header">
            <h4><?= SITE_NAME ?></h4>
            <p class="mb-0">Admin Dashboard</p>
        </div>
        <div class="sidebar-menu">
            <a href="dashboard.php" class="active"><i class="fas fa-tachometer-alt"></i> Dashboard</a>
            <a href="edit_content.php"><i class="fas fa-edit"></i> Edit Content</a>
            <a href="services.php"><i class="fas fa-tools"></i> Services</a>
<a href="projects.php"><i class="fas fa-project-diagram"></i> Projects</a>
            <a href="edit_content.php?section=gallery"><i class="fas fa-images"></i> Manage Gallery</a>
            <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
        </div>
    </div>
    
    <div class="main-content">
        <h1 class="mb-4">Dashboard</h1>
        
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        Website Sections
                    </div>
                    <div class="card-body">
                        <div class="list-group">
                            <?php foreach ($sections as $section): ?>
                            <a href="edit_content.php?section=<?= $section['section'] ?>" class="list-group-item list-group-item-action d-flex justify-content-between align-items-center">
                                <?= ucfirst($section['section']) ?>
                                <span class="badge bg-primary rounded-pill">Edit</span>
                            </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        Gallery Images
                        <a href="edit_content.php?section=gallery" class="btn btn-sm btn-primary">Manage Gallery</a>
                    </div>
                    <div class="card-body">
                        <?php if (count($gallery) > 0): ?>
                        <div class="row">
                            <?php foreach (array_slice($gallery, 0, 4) as $image): ?>
                            <div class="col-6 mb-3">
                                <img src="../<?= $image['image_url'] ?>" alt="Gallery Image" class="img-fluid gallery-img w-100">
                            </div>
                            <?php endforeach; ?>
                        </div>
                        <?php else: ?>
                        <p class="text-muted">No gallery images yet.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header">
                Quick Actions
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3 mb-3">
                        <a href="edit_content.php?section=hero" class="btn btn-primary w-100">
                            <i class="fas fa-home"></i> Edit Hero
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="edit_content.php?section=about" class="btn btn-primary w-100">
                            <i class="fas fa-info-circle"></i> Edit About
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="edit_content.php?section=contact" class="btn btn-primary w-100">
                            <i class="fas fa-envelope"></i> Edit Contact
                        </a>
                    </div>
                    <div class="col-md-3 mb-3">
                        <a href="edit_content.php?section=gallery" class="btn btn-primary w-100">
                            <i class="fas fa-images"></i> Manage Gallery
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>