<?php
require_once 'includes/config.php';
require_once 'includes/db.php';

// Get all website content
$content = [];
$result = $pdo->query("SELECT * FROM website_content");
while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
    $content[$row['section']] = $row;
}

// Get gallery images
$gallery = $pdo->query("SELECT * FROM gallery_images ORDER BY uploaded_at DESC")->fetchAll(PDO::FETCH_ASSOC);

$services = $pdo->query("SELECT * FROM services ORDER BY created_at DESC")->fetchAll(PDO::FETCH_ASSOC);

// Get projects from database
$projects = $pdo->query("SELECT * FROM projects ORDER BY completed_date DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<?php
include('includes/header.php');
?>
<section class="about" id="about">
    <div class="container">
        <div class="section-title">
            <h2>About Us</h2>
        </div>
        <div class="about-content">
            <div class="about-text">
                <h3><?= $content['about']['title'] ?? 'Presentation of Ets Taher' ?></h3>
                <p><?= $content['about']['content'] ?? 'Ets Taher is a Mauritanian company specialized in civil engineering, earthworks, industrial assembly, and welding.' ?></p>
              
            </div>
            <div class="about-image">
                <img src="<?= $content['about']['image_url'] ?? 'assets/images/default-about.jpg' ?>" alt="About Ets Taher">
            </div>
        </div>
    </div>
</section>
<section class="full-about" id="full-about">
    <div class="container">
        <!-- Resources Section -->
        <div class="about-section resources-section">
            <div class="section-header">
                <i class="fas fa-cogs"></i>
                <h3>Our Human and Technical Resources</h3>
            </div>
            <div class="resources-grid">
                <div class="resource-item">
                    <div class="resource-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <h4>Expert Team</h4>
                    <p>A multidisciplinary technical team (site managers, masons, welders, machine operators, surveyors) trained under international supervision.</p>
                </div>
                
                <div class="resource-item">
                    <div class="resource-icon">
                        <i class="fas fa-truck-monster"></i>
                    </div>
                    <h4>Modern Fleet</h4>
                    <p>A fleet of heavy equipment adapted for large-scale works: excavators, graders, compactors, dump trucks, loaders, water tankers, etc.</p>
                </div>
                
                <div class="resource-item">
                    <div class="resource-icon">
                        <i class="fas fa-clipboard-check"></i>
                    </div>
                    <h4>Quality Systems</h4>
                    <p>Internal procedures for quality control, planning, reporting, and HSE management.</p>
                </div>
                
                <div class="resource-item">
                    <div class="resource-icon">
                        <i class="fas fa-bolt"></i>
                    </div>
                    <h4>Rapid Deployment</h4>
                    <p>Fast mobilization capacity, even in remote or difficult areas, with autonomous logistics (accommodation, catering, site security).</p>
                </div>
            </div>
        </div>
        
        <!-- Experience Section -->
        <div class="about-section experience-section">
            <div class="section-header">
                <i class="fas fa-medal"></i>
                <h3>Proven Experience and References</h3>
            </div>
            <div class="experience-content">
                <p>Our current team has contributed to many projects in Tasiast and across Mauritania, including:</p>
                <ul class="experience-list">
                    <li><i class="fas fa-check-circle"></i> Construction of platforms for pumping stations, compressors, and generators</li>
                    <li><i class="fas fa-check-circle"></i> Building of access roads for safety and internal logistics</li>
                    <li><i class="fas fa-check-circle"></i> Fabrication and installation of metal structures for shelters, hangars, and technical buildings</li>
                    <li><i class="fas fa-check-circle"></i> Quality monitoring, compliance with deadlines, and adherence to environmental requirements</li>
                </ul>
                <div class="projects-gallery">
                    <!-- Would contain project images with lightbox functionality -->
                    <div class="project-thumbnail" style="background-image: url('assets/images/project1.jpg')"></div>
                    <div class="project-thumbnail" style="background-image: url('assets/images/project2.jpg')"></div>
                    <div class="project-thumbnail" style="background-image: url('assets/images/project3.jpg')"></div>
                </div>
            </div>
        </div>
        
        <!-- Commitments Section -->
        <div class="about-section commitments-section">
            <div class="section-header">
                <i class="fas fa-handshake"></i>
                <h3>Our Commitments</h3>
            </div>
            <div class="commitments-grid">
                <div class="commitment-item">
                    <div class="commitment-icon safety">
                        <i class="fas fa-shield-alt"></i>
                    </div>
                    <h4>Safety First</h4>
                    <p>Strict compliance with HSE procedures. Zero accidents is our primary goal.</p>
                </div>
                
                <div class="commitment-item">
                    <div class="commitment-icon quality">
                        <i class="fas fa-award"></i>
                    </div>
                    <h4>Quality Assurance</h4>
                    <p>Certified materials, precise execution, and ongoing quality checks.</p>
                </div>
                
                <div class="commitment-item">
                    <div class="commitment-icon responsiveness">
                        <i class="fas fa-clock"></i>
                    </div>
                    <h4>Responsiveness</h4>
                    <p>Capacity to adapt to site constraints and client demands.</p>
                </div>
                
                <div class="commitment-item">
                    <div class="commitment-icon partnership">
                        <i class="fas fa-comments"></i>
                    </div>
                    <h4>Transparent Partnership</h4>
                    <p>Open communication, regular updates, and daily or weekly reporting as required.</p>
                </div>
            </div>
        </div>
        
        <!-- Ambitions Section -->
        <div class="about-section ambitions-section">
            <div class="section-header">
                <i class="fas fa-bullseye"></i>
                <h3>Our Ambitions</h3>
            </div>
            <div class="ambitions-content">
                <p>Etablissement Taher aims to become a strategic reference partner in civil engineering and infrastructure works in Mauritania. By leveraging the skills of its team, technical discipline, and a focus on trust-based relationships, the company is committed to building long-term partnerships with its clients.</p>
                <div class="vision-statement">
                    <blockquote>
                        <i class="fas fa-quote-left"></i>
                        <p>Building Mauritania's infrastructure with excellence, safety, and innovation.</p>
                        <footer>- Ets Taher Vision</footer>
                    </blockquote>
                </div>
            </div>
        </div>
    </div>
</section>


<footer>
        <div class="container">
            <div class="social-links">
                <a href="#"><i class="fab fa-facebook-f"></i></a>
                <a href="#"><i class="fab fa-twitter"></i></a>
                <a href="#"><i class="fab fa-linkedin-in"></i></a>
                <a href="#"><i class="fab fa-instagram"></i></a>
            </div>
            <ul class="footer-links">
                <li><a href="#home">Home</a></li>
                <li><a href="#about">About</a></li>
                <li><a href="#services">Services</a></li>
                <li><a href="#projects">Projects</a></li>
                <li><a href="#gallery">Gallery</a></li>
                <li><a href="#contact">Contact</a></li>
            </ul>
            <p>&copy; <?= date('Y') ?> Ets Taher. All Rights Reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
    <script src="assets/js/script.js"></script>
</body>
</html>